/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.items.components;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.blocks.components.ABlockBase;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityPlacedPart;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.items.components.IItemEntityProvider;
import minecrafttransportsimulator.jsondefs.JSONPart;
import minecrafttransportsimulator.jsondefs.JSONPartDefinition;
import minecrafttransportsimulator.jsondefs.JSONSubDefinition;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.systems.ConfigSystem;

public abstract class AItemPart
extends AItemSubTyped<JSONPart>
implements IItemEntityProvider {
    public AItemPart(JSONPart definition, JSONSubDefinition subDefinition, String sourcePackID) {
        super(definition, subDefinition, sourcePackID);
    }

    @Override
    public boolean onBlockClicked(AWrapperWorld world, IWrapperPlayer player, Point3D position, ABlockBase.Axis axis) {
        if (((JSONPart)this.definition).generic.canBePlacedOnGround) {
            if (!world.isClient()) {
                position.add(0.5, 0.0, 0.5).add(axis.xOffset, axis.yOffset, axis.zOffset);
                for (EntityPlacedPart existingEntity : world.getEntitiesOfType(EntityPlacedPart.class)) {
                    if (!existingEntity.position.equals(position)) continue;
                    return true;
                }
                double yRotation = Math.round((player.getYaw() + 180.0f) / 90.0f) * 90 % 360;
                this.placeOnGround(world, player, position, yRotation, player.getHeldStack().getData());
                if (!player.isCreative()) {
                    player.getInventory().removeFromSlot(player.getHotbarIndex(), 1);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void populateRepairMaterials(List<String> materials, int recipeIndex) {
        super.populateRepairMaterials(materials, recipeIndex);
        if (!((List)ConfigSystem.settings.general.defaultPartRepairMaterials.value).isEmpty()) {
            materials.addAll((Collection)ConfigSystem.settings.general.defaultPartRepairMaterials.value);
        }
    }

    @Override
    public void registerEntities(Map<String, IItemEntityProvider.IItemEntityFactory> entityMap) {
        entityMap.put(EntityPlacedPart.class.getSimpleName(), (world, data) -> new EntityPlacedPart(world, null, data));
    }

    public void placeOnGround(AWrapperWorld world, IWrapperPlayer player, Point3D position, double yRotation, IWrapperNBT data) {
        EntityPlacedPart entity = new EntityPlacedPart(world, player, null);
        entity.addPartFromStack(this.getNewStack(data), player, 0, true, false);
        entity.position.set(position);
        entity.prevPosition.set(position);
        entity.orientation.setToAngles(new Point3D(0.0, yRotation, 0.0));
        entity.prevOrientation.set(entity.orientation);
        entity.world.spawnEntity(entity);
    }

    public boolean isPartValidForPackDef(JSONPartDefinition placementDefinition, JSONSubDefinition subDefinition, boolean checkMinMax) {
        if (placementDefinition.types.contains(((JSONPart)this.definition).generic.type) && (placementDefinition.validSubNames == null || placementDefinition.validSubNames.contains(subDefinition.subName))) {
            if (placementDefinition.customTypes == null) {
                return ((JSONPart)this.definition).generic.customType == null;
            }
            if (((JSONPart)this.definition).generic.customType == null) {
                return placementDefinition.customTypes == null || placementDefinition.customTypes.contains("");
            }
            return placementDefinition.customTypes.contains(((JSONPart)this.definition).generic.customType);
        }
        return false;
    }

    public abstract APart createPart(AEntityF_Multipart<?> var1, IWrapperPlayer var2, JSONPartDefinition var3, IWrapperNBT var4);

    public static abstract class AItemPartCreator {
        public abstract boolean isCreatorValid(JSONPart var1);

        public abstract AItemPart createItem(JSONPart var1, JSONSubDefinition var2, String var3);
    }
}

